/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEASAB;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEASpeakerAllocDataBlock
extends DataBlock {
    private ArrayList<CEASAB> aSABs = new ArrayList();
    private static final int maxNumDescriptors = 1;
    private static final int descriptorSize = 3;
    private static final int iSpkrTag = 4;

    public CEASpeakerAllocDataBlock() {
        super(3);
        this.iDataBlockTagCode = 4;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aSABs.remove(n);
        this.adjustNumDescriptors(-1);
    }

    @Override
    public void removeAllDescriptors() {
        this.aSABs.clear();
        this.adjustNumDescriptors(0);
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.SPKR_ALLOC_DES.getBlockName();
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        CEASAB cEASAB = (CEASAB)cEADescriptor;
        if (this.aSABs == null) {
            this.aSABs = new ArrayList(1);
        }
        if (this.aSABs.size() == 1) {
            bl = false;
        } else {
            this.aSABs.add(cEASAB);
            this.adjustNumDescriptors(1);
            bl = true;
        }
        return bl;
    }

    public ArrayList<CEASAB> getDescriptors() {
        return this.aSABs;
    }

    public void clearDescriptors() {
        this.aSABs.clear();
        this.aSABs = null;
        this.adjustNumDescriptors(0);
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        super.setHeader(string.substring(0, 2));
        if (this.getCurrentNumDescriptors() != (string.length() - 2) / 6) {
            string2 = "ERROR: Descriptor length doesn't match length of descriptors";
            return string2;
        }
        CEASAB cEASAB = new CEASAB();
        cEASAB.uploadDescriptorData(string.substring(2, 8));
        this.aSABs.add(cEASAB);
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        String string = new String(super.getHeader());
        for (int i = 0; i < this.getCurrentNumDescriptors(); ++i) {
            string = string.concat(this.aSABs.get(i).extractDescriptorData());
        }
        return string;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }
}

